package com.jugg.agile.middleware.redis.adapter.jedis;

import com.jugg.agile.middleware.redis.config.JaRedisPoolConfig;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class JaJedisPoolConfig {

    public static GenericObjectPoolConfig create(JaRedisPoolConfig pool) {
        // Jedis连接池配置
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setTestWhileIdle(true);
        poolConfig.setMinEvictableIdleTimeMillis(60000);
        poolConfig.setTimeBetweenEvictionRunsMillis(30000);
        poolConfig.setNumTestsPerEvictionRun(-1);

        // 提供了后进先出(LIFO)与先进先出(FIFO)两种行为模式的池。默认为true，
        // 即当池中有空闲可用的对象时，调用borrowObject方法会返回最近（后进）的实例
        poolConfig.setLifo(true);
        // 当从池中获取资源或者将资源还回池中时
        // 是否使用java.util.concurrent.locks.ReentrantLock.ReentrantLock 的公平锁机制,默认为false
        poolConfig.setFairness(false);
        // 获取连接时的最大等待毫秒数(如果设置为阻塞时BlockWhenExhausted),
        // 如果超时就抛异常, 小于零:阻塞不确定的时间,  默认-1
        // 当连接池资源耗尽时，等待时间，超出则抛异常，默认为-1即永不超时
        // 设置2秒
        poolConfig.setMaxWaitMillis(2000);
        // 连接空闲的最小时间，达到此值后空闲连接将可能会被移除。默认为1000L*60L*30L
        poolConfig.setMinEvictableIdleTimeMillis(BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS);
        // 连接空闲的最小时间，达到此值后空闲链接将会被移除，且保留minIdle个空闲连接数
        poolConfig.setSoftMinEvictableIdleTimeMillis(BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS);
        // 在每次空闲连接回收器线程(如果有)运行时检查的连接数量，默认为3
        poolConfig.setNumTestsPerEvictionRun(BaseObjectPoolConfig.DEFAULT_NUM_TESTS_PER_EVICTION_RUN);
        // 回收evict策略的类名，默认为org.apache.commons.pool2.impl.DefaultEvictionPolicy
        poolConfig.setEvictionPolicyClassName("org.apache.commons.pool2.impl.DefaultEvictionPolicy");
        // 默认false，create的时候检测是有有效，如果无效则从连接池中移除，并尝试获取继续获取
        poolConfig.setTestOnCreate(false);
        // 默认false，borrow的时候检测是有有效，如果无效则从连接池中移除，并尝试获取继续获取
        poolConfig.setTestOnBorrow(false);
        // 默认false，return的时候检测是有有效，如果无效则从连接池中移除，并尝试获取继续获取
        poolConfig.setTestOnReturn(false);
        // 默认false，在evict线程里头，当evictionPolicy.evict方法返回false时，
        // 而且testWhileIdle为true的时候则检测是否有效，如果无效则移除
        poolConfig.setTestWhileIdle(true);
        // 空闲链接检测线程检测的周期，毫秒数。如果为负值，表示不运行检测线程。默认为-1
        poolConfig.setTimeBetweenEvictionRunsMillis(BaseObjectPoolConfig.DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS);
        // 当这个值为true的时候，maxWaitMillis参数才能生效。为false的时候，当连接池没资源，则立马抛异常。默认为true
        poolConfig.setBlockWhenExhausted(true);

        if (null == pool) {
            pool = new JaRedisPoolConfig();
        }

        // 最大空闲连接数, 默认8个
        poolConfig.setMaxIdle(pool.getMaxIdle());
        // 最大连接数, 默认8个
        poolConfig.setMaxTotal(pool.getMaxTotal());
        // 最小空闲连接数, 默认0
        poolConfig.setMinIdle(pool.getMinIdle());
        return poolConfig;
    }
}
