package com.jugg.agile.middleware.redis.adapter.jedis;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.middleware.redis.JaRedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

import java.util.ArrayList;
import java.util.List;


/**
 * 注意高低版本jedis包路径变化
 * import redis.clients.jedis.ScanParams;
 * import redis.clients.jedis.ScanResult;
 *
 * @author chenjian
 * @since 2024年04月21日 19:06:11
 */
public class JaJedisScan {


    public static void scan(Jedis jedis, String pattern, Integer count, JaFunctionP<List<String>> jaFunctionD) {
        // 游标初始值为0
        int cursor = 0;
        ScanParams scanParams = new ScanParams();
        scanParams.match(pattern);// 匹配以 PLFX-ZZSFP-* 为前缀的 key
        scanParams.count(count);
        do {
            //使用scan命令获取数据，使用cursor游标记录位置，下次循环使用
            ScanResult<String> scanResult = jedis.scan(cursor, scanParams);
            cursor = scanResult.getCursor();// 返回0 说明遍历完成
            List<String> list = scanResult.getResult();
            jaFunctionD.apply(list);
        } while (!"0".equals(cursor));
    }

    public static void main(String[] args) {
        List<String> keyList = new ArrayList<>();
        String password = "oppo_gcsm_dev@2022";
        String sit_password = "YBb4U7cMDHaVbcMI";
        String devUrls = "10.176.226.169:9736,10.176.226.170:9736,10.176.226.164:9736";
        String sitUrls = "10.225.192.50:9736,10.225.192.51:9736,10.225.192.48:9736";
        String devDNS = "gcss-gcsm-middleware-zx-dev.redis.oppo.dev:6379";
        JaProperty.getPropertyMap().put("ja.redis.cluster", devDNS);
        JaProperty.getPropertyMap().put("ja.redis.password", password);


        String string = JaRedis.getString("basic:function:internal:administrative-division::CN");
        for (String url : devUrls.split(",")) {
            try (Jedis jedis = JaJedisConnection.create(url, password)) {
                scan(jedis, "*", 10000, strings -> {
                    for (String s : strings) {
                        if (s.contains("administrative-division")) {
                            System.out.println(s);
                        }
                    }
                });
            }
        }

        // 499336
        // 166385
        System.out.println(keyList.size());

    }
}
