/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.spring;

import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import com.jugg.agile.framework.core.util.unsafe.JaUnsafe;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class JaNodeSpanRedisTemplate
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean.getClass().getName().startsWith("org.springframework.data.redis.core.RedisTemplate") || bean.getClass().getName().startsWith("org.springframework.data.redis.core.StringRedisTemplate")) {
            JaRedisTemplateMethodInterceptor methodInterceptor = new JaRedisTemplateMethodInterceptor();
            if (bean instanceof RedisTemplate) {
                this.proxy(bean, ((RedisTemplate)this.getSingletonTarget(bean)).opsForValue(), methodInterceptor, "valueOps");
                this.proxy(bean, ((RedisTemplate)this.getSingletonTarget(bean)).opsForList(), methodInterceptor, "listOps");
                this.proxy(bean, ((RedisTemplate)this.getSingletonTarget(bean)).opsForZSet(), methodInterceptor, "zSetOps");
                this.proxy(bean, ((RedisTemplate)this.getSingletonTarget(bean)).opsForGeo(), methodInterceptor, "geoOps");
                this.proxy(bean, ((RedisTemplate)this.getSingletonTarget(bean)).opsForHyperLogLog(), methodInterceptor, "hllOps");
                this.proxy(bean, ((RedisTemplate)this.getSingletonTarget(bean)).opsForSet(), methodInterceptor, "setOps");
            }
        }
        return bean;
    }

    private void proxy(Object redisTemplate, Object opsObject, JaRedisTemplateMethodInterceptor methodInterceptor, String opsFieldName) {
        JaUnsafe.setObjectFieldValue((Object)this.getSingletonTarget(redisTemplate), (String)opsFieldName, (Object)JaSpringAopUtil.getProxy((Object)opsObject, (MethodInterceptor)methodInterceptor));
    }

    private Object getSingletonTarget(Object redisTemplate) {
        Object singletonTarget = AopProxyUtils.getSingletonTarget((Object)redisTemplate);
        return null == singletonTarget ? redisTemplate : singletonTarget;
    }

    static class JaRedisTemplateMethodInterceptor
    implements MethodInterceptor {
        JaRedisTemplateMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            NodeSpan nodeSpan = NodeSpan.builder().id(JaAopUtil.getSimpleName((MethodInvocation)invocation)).nodeKind(NodeKind.Constant.Redis).build();
            Object[] reqArgs = invocation.getArguments();
            return JaDapper.dapperAop((NodeSpan)nodeSpan, (Object[])reqArgs, (MethodInvocation)invocation);
        }
    }
}

