/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.spring;

import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import com.jugg.agile.framework.core.util.reflect.JaReflectUtil;
import com.jugg.agile.framework.core.util.unsafe.JaUnsafe;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JaNodeSpanRedisTemplate
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean.getClass().getName().startsWith("org.springframework.data.redis.core.RedisTemplate") || bean.getClass().getName().startsWith("org.springframework.data.redis.core.StringRedisTemplate")) {
            JaRedisTemplateMethodInterceptor methodInterceptor = new JaRedisTemplateMethodInterceptor();
            this.proxy(bean, methodInterceptor, "valueOps");
            this.proxy(bean, methodInterceptor, "listOps");
            this.proxy(bean, methodInterceptor, "streamOps");
            this.proxy(bean, methodInterceptor, "zSetOps");
            this.proxy(bean, methodInterceptor, "geoOps");
            this.proxy(bean, methodInterceptor, "hllOps");
            this.proxy(bean, methodInterceptor, "clusterOps");
        }
        return bean;
    }

    private void proxy(Object bean, JaRedisTemplateMethodInterceptor methodInterceptor, String opsFieldName) {
        JaUnsafe.setObjectFieldValue((Object)bean, (String)opsFieldName, (Object)JaSpringAopUtil.getProxy((Object)JaReflectUtil.getFieldValue((Object)bean, (String)opsFieldName), (MethodInterceptor)methodInterceptor));
    }

    static class JaRedisTemplateMethodInterceptor
    implements MethodInterceptor {
        JaRedisTemplateMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            NodeSpan nodeSpan = NodeSpan.builder().id(JaAopUtil.getSimpleName((MethodInvocation)invocation)).nodeKind(NodeKind.Constant.Redis).build();
            Object[] reqArgs = invocation.getArguments();
            return JaDapper.dapperAop((NodeSpan)nodeSpan, (Object[])reqArgs, (MethodInvocation)invocation);
        }
    }
}

