package com.jugg.agile.middleware.redis;

import java.util.List;

/**
 * redis api
 *
 * @author chenjian
 * @since 2020年09月10日 17:49:34
 */
public interface JaRedisCommand {

    Boolean set(String key, String value, Long... seconds);

    Boolean setNx(String key, String value, Long... seconds);

    Boolean exists(String key);

    Long del(String key);

    String get(String key);

    /**
     * 设置过期时间
     */
    Long expire(String key, Long seconds);

    /**
     * 自增, 也可以控制增加数
     */
    Long incr(String key, Long... increment);

    /**
     * 自减少, 也可以控制减少数
     */
    Long decr(String key, Long... decrement);

    Object eval(String script, List<String> keys, Object... args);

    /**
     * LIFO, get 0 永远都是最新的
     */
    Long lpush(String key, String... args);

    /**
     * FIFO, get 0 不会变
     */
    Long rpush(String key, String... args);

    /**
     * @param start 从0开始
     * @param end -1取所有
     */
    List<String> lrange(String key, long start, long end);

    /**
     * @param index 从0开始, 精准取list某个值
     */
    String lindex(final String key, long index);

}
