package com.jugg.agile.middleware.redis.adapter.jedis.pool;

import com.jugg.agile.middleware.redis.adapter.jedis.JaJedisPoolConfig;
import com.jugg.agile.middleware.redis.config.JaRedisConfig;
import com.jugg.agile.middleware.redis.config.JaRedisSimpleConfig;
import com.jugg.agile.middleware.redis.config.JaRedisPoolConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisSimplePool {

    private JedisSimplePool() {
    }

    private static final JedisPool jedisPool;

    public static Jedis get() {
        return jedisPool.getResource();
    }

    public static JedisPool getJedisPool() {
        return jedisPool;
    }

    static {
        JaRedisConfig config = JaRedisConfig.load();
        JaRedisPoolConfig pool = config.getPool();
        JaRedisSimpleConfig simple = config.getSimple();

        GenericObjectPoolConfig<Connection> poolConfig = JaJedisPoolConfig.create(pool);

        jedisPool = new JedisPool(poolConfig
                , simple.getHost()
                , simple.getPort()
                , config.getConnectionTimeout()
                , config.getSoTimeout()
                , config.getUser()
                , config.getPassword()
                , simple.getDatabase()
                , simple.getClientName()
        );

    }

}
