/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.adapter.jedis.command;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.redis.JaRedisCommand;
import com.jugg.agile.middleware.redis.adapter.jedis.pool.JedisSimplePool;
import com.jugg.agile.middleware.redis.meta.JaRedisConstants;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import redis.clients.jedis.Jedis;

public class JaJedisSimpleCommand
implements JaRedisCommand {
    @Override
    public Boolean set(String key, String value, Long ... seconds) {
        try (Jedis jedis = JedisSimplePool.get();){
            Boolean bl = "OK".equals(JaCollectionUtil.isEmpty((Object[])seconds) ? jedis.set(key, value) : jedis.setex(key, seconds[0].intValue(), value));
            return bl;
        }
    }

    @Override
    public Boolean setNx(String key, String value, Long ... seconds) {
        try (Jedis jedis = JedisSimplePool.get();){
            Boolean bl = JaRedisConstants.LuaSuccess.equals(JaCollectionUtil.isEmpty((Object[])seconds) ? jedis.setnx(key, value) : jedis.eval("if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then return redis.call('expire', KEYS[1], ARGV[2]) else return 0 end", Collections.singletonList(key), Arrays.asList(value, seconds[0].toString())));
            return bl;
        }
    }

    @Override
    public Boolean exists(String key) {
        try (Jedis jedis = JedisSimplePool.get();){
            Boolean bl = jedis.exists(key);
            return bl;
        }
    }

    @Override
    public Long del(String key) {
        try (Jedis jedis = JedisSimplePool.get();){
            Long l = jedis.del(key);
            return l;
        }
    }

    @Override
    public String get(String key) {
        try (Jedis jedis = JedisSimplePool.get();){
            String string = jedis.get(key);
            return string;
        }
    }

    @Override
    public Long expire(String key, Long seconds) {
        try (Jedis jedis = JedisSimplePool.get();){
            Long l = jedis.expire(key, seconds.intValue());
            return l;
        }
    }

    @Override
    public Long incr(String key, Long ... increment) {
        try (Jedis jedis = JedisSimplePool.get();){
            if (JaCollectionUtil.isEmpty((Object[])increment)) {
                Long l = jedis.incr(key);
                return l;
            }
            Long l = jedis.incrBy(key, increment[0].longValue());
            return l;
        }
    }

    @Override
    public Long decr(String key, Long ... increment) {
        try (Jedis jedis = JedisSimplePool.get();){
            if (JaCollectionUtil.isEmpty((Object[])increment)) {
                Long l = jedis.decr(key);
                return l;
            }
            Long l = jedis.decrBy(key, increment[0].longValue());
            return l;
        }
    }

    @Override
    public Object eval(String script, List<String> keys, Object ... args) {
        try (Jedis jedis = JedisSimplePool.get();){
            Object object = jedis.eval(script, keys, JaCollectionUtil.toStringList((Object[])args));
            return object;
        }
    }

    @Override
    public Long lpush(String key, String ... args) {
        try (Jedis jedis = JedisSimplePool.get();){
            Long l = jedis.lpush(key, args);
            return l;
        }
    }

    @Override
    public Long rpush(String key, String ... args) {
        try (Jedis jedis = JedisSimplePool.get();){
            Long l = jedis.rpush(key, args);
            return l;
        }
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        try (Jedis jedis = JedisSimplePool.get();){
            List list = jedis.lrange(key, start, end);
            return list;
        }
    }

    @Override
    public String lindex(String key, long index) {
        try (Jedis jedis = JedisSimplePool.get();){
            String string = jedis.lindex(key, index);
            return string;
        }
    }

    @Override
    public Long lrem(String key, long count, String value) {
        try (Jedis jedis = JedisSimplePool.get();){
            Long l = jedis.lrem(key, count, value);
            return l;
        }
    }
}

