package com.jugg.agile.middleware.redis.adapter.redisson;

import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;
import com.jugg.agile.framework.meta.dto.JaPageReqDTO;
import com.jugg.agile.framework.meta.dto.JaResultDTO;
import com.jugg.agile.middleware.redis.JaRedis;
import com.jugg.agile.middleware.redis.adapter.jedis.JaJedisPoolConfig;
import com.jugg.agile.middleware.redis.config.JaRedisConfig;
import com.jugg.agile.middleware.redis.config.JaRedisPoolConfig;
import com.jugg.agile.middleware.redis.config.JaRedisSimpleConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.IOException;
import java.util.HashMap;

/**
 * 不会自动拼接应用名, 会重复, 用来共有
 *
 * @author chenjian
 * @since 2020年09月03日 10:38:17
 */
public class JaRedissonSimpleAdapter {
    public static void main(String[] args) throws IOException, InterruptedException {
        String key = "";
        Object getvalue = JaRedis.cache(() -> {
                    return JaRedis.getString(key);
                }
                , () -> {
                    return new HashMap<>().get(key);
                }
                , t -> {
                    // 都没get到
                });


        JaPageReqDTO jaPageReqDTO = new JaPageReqDTO();
        JaResultDTO<JaPageReqDTO> jaPageReqDTOJaResultDTO = new JaResultDTO<>(jaPageReqDTO);

        JaRedisConfig config = JaRedisConfig.load();
        config.setPassword("123456");
        JaRedisPoolConfig pool = config.getPool();
        JaRedisSimpleConfig simple = new JaRedisSimpleConfig();
        config.setSimple(simple);
        simple.setHost("172.16.2.230");
        simple.setPort(6379);

        GenericObjectPoolConfig<Jedis> poolConfig = JaJedisPoolConfig.create(pool);

        JedisPool jedisPool = new JedisPool(poolConfig
                , simple.getHost()
                , simple.getPort()
                , config.getConnectionTimeout()
                , config.getSoTimeout()
                , config.getUser()
                , config.getPassword()
                , simple.getDatabase()
                , simple.getClientName()
        );

        System.out.println(jedisPool.getResource().get("demo"));


        RedissonClient redisson = createRedissonClient();
        for (int i = 0; i < 100; i++) {
            JaThreadPool.execute(() -> {
                long start = System.currentTimeMillis();
                // 存储对象
                RBucket<JaResultDTO<JaPageReqDTO>> demo = redisson.getBucket("demo");
                demo.set(jaPageReqDTOJaResultDTO);
                System.out.println(System.currentTimeMillis() - start);
            });
            JaThreadPool.execute(() -> {
                long start = System.currentTimeMillis();
                RBucket<String> demo = redisson.getBucket("demo");
                System.out.println("String:" + demo.get());
                System.out.println(System.currentTimeMillis() - start);
            });
        }


    }

    private static RedissonClient createRedissonClient() {
        Config config = new Config();

        // 配置单机Redis连接
        config.useSingleServer()
                .setAddress("redis://172.16.2.230:6379")  // Redis地址
                .setPassword("123456")  // 如果有密码就设置，没有就设为null
                .setDatabase(0)     // 选择数据库，默认为0
                .setConnectionPoolSize(10)  // 连接池大小
                .setConnectionMinimumIdleSize(5);  // 最小空闲连接数

        return Redisson.create(config);
    }
}
