package com.jugg.agile.middleware.redis.meta;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class JaRedisLockEntity {

    /**
     * 锁标示
     */
    private String lockKey;

    /**
     * 超时时间, 超时之后锁自动释放, 单位:s
     */
    @Builder.Default
    private long timeout = 120;

    /**
     * 自旋时间, -1(小于等于0) : 不自旋, 单位:ms
     * <p>
     * 注意自旋时间严格控制,不要太大
     */
    @Builder.Default
    private long spinTime = -1;
    @Builder.Default
    private long spinNum = 0;

    /**
     * 是否支持事务
     */
    @Builder.Default
    private boolean tx = true;

    @Builder.Default
    private String message = "重复调用, 请稍后重试";

    /**
     * api name
     */
    private String apiName;
}