/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaValidateUtil;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;
import com.jugg.agile.middleware.redis.JaRedis;
import com.jugg.agile.middleware.redis.meta.JaRedisLockEntity;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JaRedisLock {
    private static long maxSpinTime;
    private static final JaThreadLocal<String> reentrantRequestId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T lock(JaRedisLockEntity entity, Callable<T> callable) {
        if (JaStringUtil.isNotEmpty((String)((String)reentrantRequestId.get()))) {
            JaLog.get().info("lock reentry");
            return callable.call();
        }
        String lockKey = entity.getLockKey();
        String apiName = entity.getApiName();
        if (JaStringUtil.isEmpty((String)lockKey)) {
            JaLog.get().info("lockKey is null,{}", (Object)apiName);
            return callable.call();
        }
        JaLog.get().info("lockKey:{}", (Object)lockKey);
        String requestId = lockKey + System.currentTimeMillis();
        long timeout = entity.getTimeout();
        long spinTime = entity.getSpinTime();
        boolean lock = JaRedis.setNx(lockKey, requestId, timeout);
        if (!lock && spinTime > 0L) {
            TimeUnit.MILLISECONDS.sleep(Math.min(spinTime, maxSpinTime));
            lock = JaRedis.setNx(lockKey, requestId, timeout);
        }
        JaValidateUtil.isTrue((!lock ? 1 : 0) != 0, entity::getMessage);
        reentrantRequestId.set((Object)requestId);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            JaRedisLock.unlock(lockKey, requestId, entity.isTx());
        }
    }

    private static void unlock(final String lockKey, final String requestId, boolean tx) {
        if (TransactionSynchronizationManager.isSynchronizationActive() && tx) {
            try {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCompletion(int status) {
                        JaRedisLock.unlock(lockKey, requestId);
                    }
                });
            }
            catch (Throwable e) {
                JaLog.get().error("Transaction afterCompletion unLock lock failed", e);
                JaRedisLock.unlock(lockKey, requestId);
            }
        } else {
            JaRedisLock.unlock(lockKey, requestId);
        }
    }

    private static void unlock(String lockKey, String requestId) {
        try {
            if (JaRedis.del(lockKey) < 1L) {
                JaLog.get().error("redis unlock fail:{}", (Object)lockKey);
            }
        }
        catch (Throwable e) {
            JaLog.get().error("redis unlock error:{}", (Object)lockKey);
        }
        finally {
            reentrantRequestId.remove();
        }
    }

    static {
        reentrantRequestId = new JaThreadLocal();
        JaPropertyListener.addAndRunCommonListener(() -> {
            maxSpinTime = JaProperty.getLong((String)"ja.redis.lock.maxSpinTime", (Long)10000L);
        });
    }
}

