/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.redis.adapter.spring.command;

import com.jugg.agile.middleware.redis.JaRedis;
import com.jugg.agile.middleware.redis.JaRedisLockCommand;
import com.jugg.agile.middleware.redis.adapter.spring.JaRedisTemplateProcessor;
import com.jugg.agile.middleware.redis.meta.JaRedisConstants;
import java.util.Collections;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;

public class JaRedisTemplateLockCommand
implements JaRedisLockCommand {
    private static final DefaultRedisScript<Long> releaseScript = new DefaultRedisScript("if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end", Long.class);
    private final RedisTemplate redisTemplate = JaRedisTemplateProcessor.getRedisTemplate();

    @Override
    public boolean lock(String lockKey, String requestId, long expireTime) {
        return JaRedis.setNx(lockKey, requestId, expireTime / 1000L);
    }

    @Override
    public boolean unLock(String lockKey, String requestId) {
        return JaRedisConstants.LuaSuccess.equals(this.redisTemplate.execute(releaseScript, Collections.singletonList(lockKey), new Object[]{requestId}));
    }
}

