package com.jugg.agile.middleware.redis.spring;

import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import com.jugg.agile.framework.core.util.reflect.JaReflectUtil;
import com.jugg.agile.framework.core.util.unsafe.JaUnsafe;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import lombok.SneakyThrows;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

/**
 * 临时方案, RedisTemplate节点简易处理
 *
 * @author chenjian
 * @since 2024年04月24日 13:55:42
 */
@Configuration
public class JaNodeSpanRedisTemplate implements BeanPostProcessor {

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean.getClass().getName().startsWith("org.springframework.data.redis.core.RedisTemplate")
                || bean.getClass().getName().startsWith("org.springframework.data.redis.core.StringRedisTemplate")
        ) {
            JaRedisTemplateMethodInterceptor methodInterceptor = new JaRedisTemplateMethodInterceptor();
            proxy(bean, methodInterceptor, "valueOps");
            proxy(bean, methodInterceptor, "listOps");
            proxy(bean, methodInterceptor, "streamOps");
            proxy(bean, methodInterceptor, "zSetOps");
            proxy(bean, methodInterceptor, "geoOps");
            proxy(bean, methodInterceptor, "hllOps");
            proxy(bean, methodInterceptor, "clusterOps");
        }
        return bean;
    }


    @SneakyThrows
    private void proxy(Object bean, JaRedisTemplateMethodInterceptor methodInterceptor, String opsFieldName) {
        JaUnsafe.setObjectFieldValue(bean, opsFieldName
                , JaSpringAopUtil.getProxy(JaReflectUtil.getFieldValue(bean, opsFieldName)
                        , methodInterceptor));
    }

    static class JaRedisTemplateMethodInterceptor implements MethodInterceptor {

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            NodeSpan nodeSpan = NodeSpan.builder()
                    .id(JaAopUtil.getSimpleName(invocation))
                    .nodeKind(NodeKind.Constant.Redis)
                    .build();
            Object[] reqArgs = invocation.getArguments();
            return JaDapper.dapperAop(nodeSpan, reqArgs, invocation);
        }
    }

}