package com.jugg.agile.middleware.redis.adapter.jedis;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.middleware.redis.JaRedis;
import redis.clients.jedis.Jedis;

public class JaJedisConnection {

    public static Jedis create(String url) {
        String[] urlArgs = url.split(":");
        return new Jedis(urlArgs[0], Integer.parseInt(urlArgs[1]));
    }

    public static Jedis create(String url, String password) {
        Jedis jedis = create(url);
        jedis.auth(password);
        return jedis;
    }


    public static void main(String[] args) {

        JaProperty.getPropertyMap().put("ja.redis.simple.host", "172.16.2.141");// dev
        JaProperty.getPropertyMap().put("ja.redis.simple.port", 6379);// dev
        JaProperty.getPropertyMap().put("ja.redis.simple.port", 6379);// dev

        String demo = JaRedis.getString("demo");
        System.out.println(demo);
        JaRedis.setString("demo", "demo");
        demo = JaRedis.getString("demo");
        System.out.println(demo);
        System.out.println(JaRedis.del("demo"));
    }
}
