package com.jugg.agile.middleware.redis.adapter.jedis.adapter;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.redis.JaRedisCommand;
import com.jugg.agile.middleware.redis.JaRedisMeta;
import com.jugg.agile.middleware.redis.adapter.jedis.pool.JedisSimplePool;
import redis.clients.jedis.Jedis;

public class JaJedisSimpleAdapter implements JaRedisCommand {
    @Override
    public Boolean set(String key, String value, Long... seconds) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return JaRedisMeta.OK.equals(JaCollectionUtil.isEmpty(seconds)
                    ? jedis.set(key, value)
                    : jedis.setex(key, seconds[0].intValue(), value)
            );
        }
    }

    @Override
    public Boolean setNx(String key, String value, Long... seconds) {
        try (Jedis jedis = JedisSimplePool.get()) {
            boolean result = 1 == jedis.setnx(key, value);
            if (result && JaCollectionUtil.isNotEmpty(seconds)) {
                expire(key, seconds[0]);
            }
            return result;
        }
    }

    @Override
    public Boolean exists(String key) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.exists(key);
        }
    }

    @Override
    public Long del(String key) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.del(key);
        }
    }

    @Override
    public String get(String key) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.get(key);
        }
    }

    @Override
    public Long expire(String key, Long seconds) {
        try (Jedis jedis = JedisSimplePool.get()) {
            return jedis.expire(key, seconds.intValue());
        }
    }

    @Override
    public Long incr(String key, Long... increment) {
        try (Jedis jedis = JedisSimplePool.get()) {
            if (JaCollectionUtil.isEmpty(increment)) {
                return jedis.incr(key);
            }
            return jedis.incrBy(key, increment[0]);
        }

    }

    @Override
    public Long decr(String key, Long... increment) {
        try (Jedis jedis = JedisSimplePool.get()) {
            if (JaCollectionUtil.isEmpty(increment)) {
                return jedis.decr(key);
            }
            return jedis.decrBy(key, increment[0]);
        }

    }
}
