package com.jugg.agile.middleware.redis.config;

import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class JaRedisConfig {
    public static final String Key_Cluster = "ja.redis.cluster";
    public static final String Key_Password = "ja.redis.password";

    /**
     * 0 : 集群
     * 1 : 哨兵
     * 3 : 主从
     */
    private int type = 0;
    /**
     * 集群模式使用
     * ip:port,ip:port,ip:port
     */
    private String cluster;

    private JaRedisSimpleConfig simple;

    private String user;

    private String password;

    /**
     * JedisSocketFactory
     * redis.clients.jedis.DefaultJedisSocketFactory#createSocket()
     * socket.connect(new InetSocketAddress(getHost(), getPort()), getConnectionTimeout());
     * <p>
     * 连接超时是指在尝试连接到 Redis 服务器时等待的最大时间。如果连接超时时间内未能建立连接，将会抛出连接超时的异常
     * 在 Jedis 中，默认的连接超时时间是 10000 毫秒（10 秒）
     */
    private Integer connectionTimeout = 10000;
    /**
     * socket.setSoTimeout(getSoTimeout());
     * <p>
     * 读取超时是指在与 Redis 服务器建立连接后，执行命令时等待服务器响应的最大时间。如果在读取超时时间内未能收到服务器响应，将会抛出读取超时的异常。
     * 在 Jedis 中，默认的读取超时时间也是 10000 毫秒（10 秒）
     */
    private Integer soTimeout = 10000;
    /**
     * redis.clients.jedis.JedisClusterCommand#runWithRetries(int, int, boolean, redis.clients.jedis.exceptions.JedisRedirectionException)
     * 执行异常重试次数
     */
    private Integer maxAttempts = 3;

    private JaRedisPoolConfig pool;

    public static JaRedisConfig load() {
        return JaYamlProcessor.getConfig("ja.redis", JaRedisConfig.class);
    }
}
