/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.rocketmq.producer;

import com.alibaba.fastjson.JSON;
import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaValidateUtil;
import com.jugg.agile.framework.meta.exception.JaException;
import com.jugg.agile.middleware.rocketmq.context.RocketMqContextChain;
import com.jugg.agile.middleware.rocketmq.message.JaRocketMqMessage;
import com.jugg.agile.middleware.rocketmq.producer.SendCallbackAdapter;
import java.util.function.Consumer;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;

public class JaRocketMqProducer {
    public static <T> void send(DefaultMQProducer producer, JaRocketMqMessage<T> message) {
        JaRocketMqProducer.send(producer, message, null);
    }

    public static <T> void send(DefaultMQProducer producer, JaRocketMqMessage<T> message, Consumer<Message> consumer) {
        JaDapper.dapper((NodeSpan)NodeSpan.builder().dapperAnnotation(message.getDapperPolicy()).id(message.getTopic() + " - " + message.getTag()).nodeKind(NodeKind.Constant.RocketMQProduce).build(), (Object[])new Object[]{message.getKey(), message.getBody()}, () -> {
            SendResult sendResult = null;
            try {
                Message msg = JaRocketMqProducer.wrapMessage(message);
                if (null != consumer) {
                    consumer.accept(msg);
                }
                switch (message.getType()) {
                    case Async: {
                        JaRocketMqProducer.async(message, msg, producer);
                        break;
                    }
                    case Order: {
                        sendResult = JaRocketMqProducer.order(message, msg, producer);
                        break;
                    }
                    case Delay: {
                        msg.setDelayTimeLevel(message.getDelayLevelEnum().getLevel());
                    }
                    case Sync: {
                        sendResult = producer.send(msg);
                        break;
                    }
                    case OneWay: {
                        producer.sendOneway(msg);
                    }
                }
                if (null != sendResult) {
                    JaLog.info((String)"send rocket mq message:{}, sendResult:{}", (Object[])new Object[]{message, sendResult});
                }
            }
            catch (Throwable e) {
                JaLog.get().error("send rocket mq message error:{}", (Object)message, (Object)e);
                throw new JaException("send rocket mq message error", new Object[]{e});
            }
            return sendResult;
        });
    }

    private static <T> SendResult order(JaRocketMqMessage<T> message, Message msg, DefaultMQProducer producer) throws Throwable {
        return producer.send(msg, (mqs, msg1, arg) -> (MessageQueue)mqs.get(Math.max(Math.abs(arg.hashCode() % mqs.size()), 0)), (Object)message.getKey());
    }

    private static <T> void async(JaRocketMqMessage<T> message, Message msg, DefaultMQProducer producer) throws Throwable {
        SendCallbackAdapter sendCallback = message.getSendCallback();
        producer.send(msg, () -> null == sendCallback ? () -> message : sendCallback);
    }

    private static <T> Message wrapMessage(JaRocketMqMessage<T> message) {
        JaValidateUtil.notNull(message, () -> "mq message is null");
        JaValidateUtil.notNull((String)message.getTopic(), () -> "mq message topic is null");
        JaValidateUtil.notNull((String)message.getTag(), () -> "mq message tag is null");
        JaValidateUtil.notNull((String)message.getKey(), () -> "mq message key is null");
        JaValidateUtil.notNull(message.getBody(), () -> "mq message body is null");
        Message msg = new Message();
        msg.setTopic(message.getTopic());
        msg.setTags(message.getTag());
        msg.setKeys(message.getKey());
        msg.setBody(JaStringUtil.getBytes((String)JSON.toJSONString(message.getBody())));
        RocketMqContextChain.getInstance().transmit().forEach((arg_0, arg_1) -> ((Message)msg).putUserProperty(arg_0, arg_1));
        return msg;
    }
}

