/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.rocketmq.producer;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.middleware.rocketmq.message.JaRocketMqMessage;
import com.jugg.agile.middleware.rocketmq.producer.JaRocketMqProducer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.rocketmq.client.producer.DefaultMQProducer;

public class JaRocketMqProducerPool {
    private static final ConcurrentHashMap<String, DefaultMQProducer> producerMap = new ConcurrentHashMap();

    public static Map<String, DefaultMQProducer> getProducerMap() {
        return producerMap;
    }

    public static synchronized DefaultMQProducer create(String producerName, String producerGroup, String namesrvAddr) {
        return JaRocketMqProducerPool.create(producerName, producerGroup, namesrvAddr, null);
    }

    /*
     * Loose catch block
     */
    public static synchronized DefaultMQProducer create(String producerName, String producerGroup, String namesrvAddr, Consumer<DefaultMQProducer> wrapper) {
        try {
            DefaultMQProducer producer;
            block6: {
                producer = producerMap.get(producerName);
                if (null == producer) break block6;
                return producer;
            }
            producer = new DefaultMQProducer(producerGroup);
            producer.setNamesrvAddr(namesrvAddr);
            producer.setMaxMessageSize(JaProperty.getInteger((String)"ja.rocketmq.maxMessageSize", (Integer)0xA00000).intValue());
            producer.setSendMsgTimeout(JaProperty.getInteger((String)"ja.rocketmq.sendMsgTimeout", (Integer)3000).intValue());
            if (null != wrapper) {
                wrapper.accept(producer);
            }
            producer.start();
            producerMap.put(producerName, producer);
            JaShutdownHookUtil.add((String)namesrvAddr, () -> ((DefaultMQProducer)producer).shutdown());
            JaLog.info((String)"rocketmq DefaultMQProducer [{}, {}, {}] create success", (Object[])new Object[]{producerName, producerGroup, namesrvAddr});
            return producer;
        }
        catch (Throwable e) {
            JaLog.get().error("rocketmq DefaultMQProducer [{}, {}, {}] create error:", new Object[]{producerName, producerGroup, namesrvAddr, e});
            throw e;
            {
                catch (Throwable $ex) {
                    throw $ex;
                }
            }
        }
    }

    public static void main(String[] args) {
        JaRocketMqProducerPool.create("default", "Test-Dev", "gcss-rocketmq-dev.rocketmq.oppo.dev:9876");
        DefaultMQProducer aDefault = JaRocketMqProducerPool.getProducerMap().get("default");
        JaRocketMqMessage<String> message = new JaRocketMqMessage<String>();
        message.setBody("demo" + System.currentTimeMillis());
        message.setTopic("Test-Dev");
        message.setTag("tag");
        message.setKey("key" + System.currentTimeMillis());
        JaRocketMqProducer.send(aDefault, message, message1 -> {
            message1.putUserProperty("gcsmUserAccount", "80320968");
            message1.putUserProperty("gcsmUserName", "80320968");
            message1.putUserProperty("gcsmUserAccountType", "1");
        });
    }
}

