/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.rocketmq.producer;

import com.jugg.agile.middleware.rocketmq.message.JaRocketMqMessage;
import com.jugg.agile.middleware.rocketmq.producer.SendCallbackAdapter;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface JaSendCallback<T>
extends SendCallback {
    public static final Logger log = LoggerFactory.getLogger(JaSendCallback.class);

    public SendCallbackAdapter<T> adapter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void onSuccess(SendResult sendResult) {
        JaRocketMqMessage<T> message = this.adapter().message();
        try {
            this.adapter().onSuccess(sendResult, message);
        }
        catch (Throwable e) {
            log.error("send rocket mq onSuccess error message:{}, sendResult:{}", new Object[]{message, sendResult, e});
        }
        finally {
            log.info("send rocket mq message:{}, sendResult:{}", message, (Object)sendResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void onException(Throwable e) {
        JaRocketMqMessage<T> message = this.adapter().message();
        try {
            this.adapter().onException(e, message);
        }
        catch (Throwable ee) {
            log.error("send rocket mq onException error message:{} e:{}", new Object[]{message, e.getMessage(), ee});
        }
        finally {
            log.error("send rocket mq message error:{}", message, (Object)e);
        }
    }
}

