package com.jugg.agile.middleware.seata.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * jugg分布式事务切面注解
 *
 * @author wuzq
 * @version 1.0.0
 * @date 2024/06/06
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface JaGlobalTransactional {
    /**
     * 全局事务超时时间
     */
    int timeoutMills() default 120000;

    /**
     * 全局事务名称
     */
    String name() default "";

    /**
     * 为配置类回滚
     *
     */
    Class<? extends Throwable>[] rollbackFor() default {};

}
