package com.jugg.agile.middleware.seata.aspect;

import com.jugg.agile.middleware.seata.JaGlobalTransactionalTemplate;
import com.jugg.agile.middleware.seata.annotation.JaGlobalTransactional;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

/**
 * jugg分布式事务切面
 *
 * @author wuzq
 * @version 1.0.0
 * @date 2024/06/06
 */

@Order(Ordered.HIGHEST_PRECEDENCE)
public class JaGlobalTransactionalAspect implements MethodInterceptor {
    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        JaGlobalTransactional annotation = method.getAnnotation(JaGlobalTransactional.class);
        TransactionInfo txInfo = null;
        if (null != annotation) {
            txInfo = new TransactionInfo();
            txInfo.setName(annotation.name());
            txInfo.setTimeOut(annotation.timeoutMills());
            Set<RollbackRule> rollbackRules = new HashSet<>();
            for (Class<?> rbRule : annotation.rollbackFor()) {
                rollbackRules.add(new RollbackRule(rbRule));
            }
            txInfo.setRollbackRules(rollbackRules);
        }

        return JaGlobalTransactionalTemplate.handleGlobalTransaction(txInfo, methodInvocation::proceed);
    }
}
