package com.jugg.agile.middleware.seata.annotation;

import io.seata.spring.annotation.GlobalLock;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * jugg分布式事务锁
 *
 * @author wuzq
 * @version 1.0.0
 * @date 2024/06/06
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Inherited
@GlobalLock
public @interface JaGlobalLock {
    @AliasFor(annotation = GlobalLock.class)
    int lockRetryInterval() default 0;

    @AliasFor(annotation = GlobalLock.class)
    int lockRetryTimes() default -1;
}
