/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.seata;

import com.jugg.agile.middleware.seata.utils.JaEnvironmentUtil;
import io.seata.common.util.CollectionUtils;
import io.seata.core.context.RootContext;
import io.seata.core.exception.TmTransactionException;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.GlobalStatus;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import io.seata.tm.api.GlobalTransactionRole;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.TransactionInfo;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaGlobalTransactionalTemplate {
    private static final Logger log = LoggerFactory.getLogger(JaGlobalTransactionalTemplate.class);

    public static Object handleGlobalTransaction(TransactionInfo txInfo, JaFunctionTR business) throws Throwable {
        Object result;
        if (!JaEnvironmentUtil.getProperty("ja.distributed-transaction.enabled", Boolean.class, true).booleanValue()) {
            return business.apply();
        }
        if (Objects.isNull(txInfo)) {
            txInfo = new TransactionInfo();
        }
        if (txInfo.getTimeOut() <= 0) {
            txInfo.setTimeOut(JaEnvironmentUtil.getProperty("ja.distributed-transaction.client-tm-default-global-transaction-timeout", Integer.class, 120000).intValue());
        }
        if (Objects.isNull(txInfo.getName()) || txInfo.getName().isEmpty()) {
            txInfo.setName(JaEnvironmentUtil.getProperty("ja.distributed-transaction.application-id", JaEnvironmentUtil.getAppName()));
        }
        GlobalTransaction tx = null;
        try {
            tx = GlobalTransactionContext.getCurrentOrCreate();
            JaGlobalTransactionalTemplate.beginTransaction(txInfo, tx);
        }
        catch (Exception e) {
            log.error("Ignore begin transaction error");
        }
        try {
            result = business.apply();
        }
        catch (Throwable e) {
            JaGlobalTransactionalTemplate.completeTransactionAfterThrowing(txInfo, tx, e);
            throw e;
        }
        JaGlobalTransactionalTemplate.commitTransaction(tx, txInfo);
        return result;
    }

    public static Object handleGlobalTransaction(TransactionInfo txInfo, JaFunctionTR business, JaFunctionTR<Boolean> judge) throws Throwable {
        if (!Objects.isNull(judge) && judge.apply().booleanValue()) {
            return JaGlobalTransactionalTemplate.handleGlobalTransaction(txInfo, business);
        }
        return business.apply();
    }

    private static void beginTransaction(TransactionInfo txInfo, GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        if (tx.getGlobalTransactionRole() != GlobalTransactionRole.Launcher) {
            log.debug("Ignore begin: just involved in global transaction [{}]", (Object)tx.getXid());
            return;
        }
        try {
            tx.begin(txInfo.getTimeOut(), txInfo.getName());
            log.info("====================\u5168\u5c40\u4e8b\u52a1id==================" + RootContext.getXID());
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.BeginFailure);
        }
    }

    private static void commitTransaction(GlobalTransaction tx, TransactionInfo txInfo) throws TransactionalExecutor.ExecutionException {
        if (tx == null) {
            return;
        }
        if (tx.getGlobalTransactionRole() != GlobalTransactionRole.Launcher) {
            log.debug("Ignore commit: just involved in global transaction [{}]", (Object)tx.getXid());
            return;
        }
        if (JaGlobalTransactionalTemplate.isTimeout(tx.getCreateTime(), txInfo.getTimeOut())) {
            TmTransactionException exx = new TmTransactionException(TransactionExceptionCode.TransactionTimeout, String.format("client detected transaction timeout before commit, so change to rollback, xid = %s", tx.getXid()));
            JaGlobalTransactionalTemplate.rollbackTransaction(tx, (Throwable)exx);
            return;
        }
        try {
            tx.commit();
            GlobalStatus afterCommitStatus = tx.getLocalStatus();
            TransactionalExecutor.Code code = TransactionalExecutor.Code.Unknown;
            switch (afterCommitStatus) {
                case TimeoutRollbacking: {
                    code = TransactionalExecutor.Code.Rollbacking;
                    break;
                }
                case TimeoutRollbacked: {
                    code = TransactionalExecutor.Code.RollbackDone;
                    break;
                }
                case Finished: {
                    code = TransactionalExecutor.Code.CommitFailure;
                    break;
                }
            }
            TmTransactionException statusException = null;
            if (GlobalStatus.isTwoPhaseHeuristic((GlobalStatus)afterCommitStatus)) {
                statusException = new TmTransactionException(TransactionExceptionCode.CommitHeuristic, String.format("Global transaction[%s] not found, may be rollbacked.", tx.getXid()));
            } else if (GlobalStatus.isOnePhaseTimeout((GlobalStatus)afterCommitStatus)) {
                statusException = new TmTransactionException(TransactionExceptionCode.TransactionTimeout, String.format("Global transaction[%s] is timeout and will be rollback[TC].", tx.getXid()));
            }
            if (null != statusException) {
                throw new TransactionalExecutor.ExecutionException(tx, statusException, code);
            }
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.CommitFailure);
        }
    }

    private static void completeTransactionAfterThrowing(TransactionInfo txInfo, GlobalTransaction tx, Throwable originalException) throws TransactionalExecutor.ExecutionException {
        if (txInfo != null && CollectionUtils.isNotEmpty((Collection)txInfo.getRollbackRules())) {
            if (txInfo.rollbackOn(originalException)) {
                JaGlobalTransactionalTemplate.rollbackTransaction(tx, originalException);
            } else {
                JaGlobalTransactionalTemplate.commitTransaction(tx, txInfo);
            }
        } else {
            JaGlobalTransactionalTemplate.rollbackTransaction(tx, originalException);
        }
    }

    private static void rollbackTransaction(GlobalTransaction tx, Throwable originalException) throws TransactionalExecutor.ExecutionException {
        TransactionalExecutor.Code code;
        if (tx == null) {
            return;
        }
        if (tx.getGlobalTransactionRole() != GlobalTransactionRole.Launcher) {
            log.debug("Ignore rollback: just involved in global transaction [{}]", (Object)tx.getXid());
            return;
        }
        try {
            tx.rollback();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.RollbackFailure, originalException);
        }
        switch (tx.getLocalStatus()) {
            case RollbackFailed: 
            case TimeoutRollbackFailed: 
            case RollbackRetryTimeout: {
                code = TransactionalExecutor.Code.RollbackFailure;
                break;
            }
            case TimeoutRollbacking: 
            case Rollbacking: 
            case RollbackRetrying: 
            case TimeoutRollbackRetrying: {
                code = TransactionalExecutor.Code.Rollbacking;
                break;
            }
            case TimeoutRollbacked: 
            case Finished: 
            case Rollbacked: {
                code = TransactionalExecutor.Code.RollbackDone;
                break;
            }
            default: {
                code = TransactionalExecutor.Code.Unknown;
                log.warn("{} rollback in the state {}", (Object)tx.getXid(), (Object)tx.getLocalStatus());
            }
        }
        throw new TransactionalExecutor.ExecutionException(tx, originalException, code, originalException);
    }

    private static boolean isTimeout(long beginTime, long timeoutMills) {
        return System.currentTimeMillis() - beginTime > timeoutMills;
    }

    @FunctionalInterface
    public static interface JaFunctionTR<R> {
        public R apply() throws Throwable;
    }
}

