/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.seata.utils;

import java.util.Objects;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class JaEnvironmentUtil
implements EnvironmentAware {
    private static final String APPLICATION_NAME_KEY = "app.name";
    private static final String DEFAULT_APPLICATION_NAME = "spring.application.name";
    private static Environment environment;

    public static Environment obtainEnvironment() {
        if (Objects.isNull(environment)) {
            throw new RuntimeException("\u83b7\u53d6\u73af\u5883\u5bf9\u8c61\u5931\u8d25");
        }
        return environment;
    }

    public void setEnvironment(Environment environment) {
        JaEnvironmentUtil.environment = environment;
    }

    public static String getProperty(String key) {
        return JaEnvironmentUtil.getProperty(key, String.class);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = JaEnvironmentUtil.getProperty(key);
        return Objects.nonNull(value) ? value : defaultValue;
    }

    public static <T> T getProperty(String key, Class<T> targetValueType) {
        return (T)JaEnvironmentUtil.obtainEnvironment().getProperty(key, targetValueType);
    }

    public static <T> T getProperty(String key, Class<T> targetValueType, T defaultValue) {
        T value = JaEnvironmentUtil.getProperty(key, targetValueType);
        return Objects.nonNull(value) ? value : defaultValue;
    }

    public static String getAppName() {
        String appId = JaEnvironmentUtil.obtainEnvironment().getProperty(APPLICATION_NAME_KEY);
        return StringUtils.hasText((String)appId) ? appId : JaEnvironmentUtil.obtainEnvironment().getProperty(DEFAULT_APPLICATION_NAME);
    }
}

