/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.seata.processor;

import com.jugg.agile.middleware.seata.properties.JaDistributedTransactionProperties;
import java.util.HashMap;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class JaSeataPostPropertyProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isCloudContainer()) {
            return;
        }
        this.checkParams(environment);
        JaDistributedTransactionProperties distributedTransactionProperties = new JaDistributedTransactionProperties();
        Binder.get((Environment)environment).bind("ja.distributed-transaction", Bindable.ofInstance((Object)distributedTransactionProperties));
        Properties seataProps = new Properties();
        seataProps.setProperty("seata.enabled", "false");
        if (distributedTransactionProperties.getEnabled().booleanValue()) {
            this.setSeataProperty("seata.application-id", environment, distributedTransactionProperties.getApplicationId(environment), seataProps, true);
            this.setSeataProperty("seata.enable-auto-data-source-proxy", environment, distributedTransactionProperties.getEnableAutoDataSourceProxy(), seataProps, false);
            this.setSeataProperty("seata.tx-service-group", environment, distributedTransactionProperties.getTxServiceGroup(), seataProps, false);
            this.setSeataProperty("seata.service.vgroupMapping", environment, distributedTransactionProperties.getServiceVgroupMapping(), seataProps, false);
            distributedTransactionProperties.getServiceVgroupMapping().forEach((k, v) -> this.setSeataProperty("seata.service.vgroupMapping." + k, environment, v, seataProps, false));
            this.setSeataProperty("seata.service.grouplist", environment, distributedTransactionProperties.getServiceGrouplist(), seataProps, false);
            distributedTransactionProperties.getServiceGrouplist().forEach((k, v) -> this.setSeataProperty("seata.service.grouplist." + k, environment, v, seataProps, false));
            this.setSeataProperty("seata.client.tm.defaultGlobalTransactionTimeout", environment, distributedTransactionProperties.getClientTmDefaultGlobalTransactionTimeout(), seataProps, false);
            this.setSeataProperty("seata.client.tm.rollbackRetryCount", environment, distributedTransactionProperties.getClientTmRollbackRetryCount(), seataProps, false);
            this.setSeataProperty("seata.client.tm.commitRetryCount", environment, distributedTransactionProperties.getClientTmCommitRetryCount(), seataProps, false);
            if ("nacos".equals(distributedTransactionProperties.getRegistryType())) {
                seataProps.setProperty("seata.registry.type", "nacos");
                this.setSeataProperty("seata.registry.nacos.server-addr", environment, distributedTransactionProperties.getNacosRegistryServerAddr(), seataProps, true);
                this.setSeataProperty("seata.registry.nacos.cluster", environment, distributedTransactionProperties.getNacosRegistryCluster(), seataProps, true);
                this.setSeataProperty("seata.registry.nacos.group", environment, distributedTransactionProperties.getNacosRegistryGroup(), seataProps, false);
                this.setSeataProperty("seata.registry.nacos.namespace", environment, distributedTransactionProperties.getNacosRegistryNameSpace(), seataProps, false);
                this.setSeataProperty("seata.registry.nacos.password", environment, distributedTransactionProperties.getNacosRegistryPassword(), seataProps, false);
                this.setSeataProperty("seata.registry.nacos.username", environment, distributedTransactionProperties.getNacosRegistryUsername(), seataProps, false);
                this.setSeataProperty("seata.registry.nacos.application", environment, distributedTransactionProperties.getNacosRegistryApplication(), seataProps, false);
            }
            if ("nacos".equals(distributedTransactionProperties.getConfigType())) {
                seataProps.setProperty("seata.config.type", "nacos");
                this.setSeataProperty("seata.config.nacos.server-addr", environment, distributedTransactionProperties.getNacosConfigServerAddr(), seataProps, true);
                this.setSeataProperty("seata.config.nacos.group", environment, distributedTransactionProperties.getNacosConfigGroup(), seataProps, false);
                this.setSeataProperty("seata.config.nacos.data-id", environment, distributedTransactionProperties.getNacosConfigDataId(), seataProps, false);
                this.setSeataProperty("seata.config.nacos.namespace", environment, distributedTransactionProperties.getNacosConfigNamespace(), seataProps, false);
                this.setSeataProperty("seata.config.nacos.password", environment, distributedTransactionProperties.getNacosConfigPassword(), seataProps, false);
                this.setSeataProperty("seata.config.nacos.username", environment, distributedTransactionProperties.getNacosConfigUsername(), seataProps, false);
            }
        }
        environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("jaSeata", seataProps));
    }

    private void checkParams(ConfigurableEnvironment environment) {
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
        if (!this.isBoolean(environment.getProperty("ja.distributed-transaction.enabled"))) {
            map.put("ja.distributed-transaction.enabled", Boolean.valueOf(false));
        }
        if (!this.isBoolean(environment.getProperty("ja.distributed-transaction.enable-auto-data-source-proxy"))) {
            map.put("ja.distributed-transaction.enable-auto-data-source-proxy", Boolean.valueOf(true));
        }
        if (!JaSeataPostPropertyProcessor.isInteger(environment.getProperty("ja.distributed-transaction.client-tm-default-global-transaction-timeout"))) {
            map.put("ja.distributed-transaction.client-tm-default-global-transaction-timeout", Integer.valueOf(120000));
        }
        MapPropertySource propertySource = new MapPropertySource("jaSeata", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    public void setSeataProperty(String propertyName, ConfigurableEnvironment environment, Object propertyValue, Properties seataProps, boolean must) {
        Object value = environment.getProperty(propertyName);
        if (StringUtils.isEmpty((Object)value)) {
            value = propertyValue;
            if (StringUtils.isEmpty((Object)value) && must) {
                throw new RuntimeException("[" + propertyName + "] is must seata config property");
            }
            seataProps.put(propertyName, value);
        }
    }

    public boolean isCloudContainer() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().endsWith("BootstrapApplicationListener")) continue;
            return true;
        }
        return false;
    }

    public boolean isBoolean(String str) {
        if (str == null) {
            return false;
        }
        String lowerCaseStr = str.toLowerCase();
        return "true".equals(lowerCaseStr) || "false".equals(lowerCaseStr);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

