package com.jugg.agile.middleware.seata.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.core.env.ConfigurableEnvironment;

import java.util.HashMap;
import java.util.Map;

import static io.seata.common.DefaultValues.*;

/**
 * jugg中使用的分布式事务配置
 *
 * @author wuzq
 * @version 1.0.0
 * @date 2024/6/6
 */
@Getter
@Setter
public class JaDistributedTransactionProperties {
    private Boolean enabled = true;
    private String applicationId;
    private Boolean enableAutoDataSourceProxy = true;
    private String txServiceGroup;

    private String registryType = "file";
    //------------------------nacos 注册中心配置------------------------
    private String nacosRegistryServerAddr;
    private String nacosRegistryCluster = "default";
    private String nacosRegistryNameSpace = "";
    private String nacosRegistryGroup = "SEATA_GROUP";
    private String nacosRegistryUsername = "";
    private String nacosRegistryPassword = "";

    private String configType = "file";
    //------------------------nacos 配置中心配置------------------------
    private String nacosConfigServerAddr;
    private String nacosConfigNamespace = "";
    private String nacosConfigGroup = "SEATA_GROUP";
    private String nacosConfigUsername = "";
    private String nacosConfigPassword = "";
    private String nacosConfigDataId = "seata.properties";

    //------------------------service------------------------
    private Map<String, String> serviceVgroupMapping = new HashMap<>();
    private Map<String, String> serviceGrouplist = new HashMap<>();

    //------------------------tm------------------------
    private int clientTmDefaultGlobalTransactionTimeout = 120000;
    private int clientTmCommitRetryCount = 5;
    private int clientTmRollbackRetryCount = 5;

    public String getApplicationId(ConfigurableEnvironment environment) {
        if (applicationId == null) {
            applicationId = environment.getProperty("spring.application.name");
        }
        return applicationId;
    }

    public String getTxServiceGroup() {
        if (txServiceGroup == null) {
            txServiceGroup = DEFAULT_TX_GROUP;
        }
        return txServiceGroup;
    }

    public Map<String, String> getServiceVgroupMapping() {
        if (serviceVgroupMapping.isEmpty()) {
            serviceVgroupMapping.put(DEFAULT_TX_GROUP, DEFAULT_TC_CLUSTER);
        }
        return serviceVgroupMapping;
    }

    public Map<String, String> getServiceGrouplist() {
        if (serviceGrouplist.isEmpty()) {
            serviceGrouplist.put(DEFAULT_TC_CLUSTER, DEFAULT_GROUPLIST);
        }
        return serviceGrouplist;
    }
}
