/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.seata.aspect;

import com.jugg.agile.middleware.seata.JaGlobalTransactionalTemplate;
import com.jugg.agile.middleware.seata.annotation.JaGlobalTransactional;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class JaGlobalTransactionalAspect
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        JaGlobalTransactional annotation = method.getAnnotation(JaGlobalTransactional.class);
        TransactionInfo txInfo = null;
        if (null != annotation) {
            txInfo = new TransactionInfo();
            txInfo.setName(annotation.name());
            txInfo.setTimeOut(annotation.timeoutMills());
            HashSet<RollbackRule> rollbackRules = new HashSet<RollbackRule>();
            for (Class<? extends Throwable> rbRule : annotation.rollbackFor()) {
                rollbackRules.add(new RollbackRule(rbRule));
            }
            txInfo.setRollbackRules(rollbackRules);
        }
        return JaGlobalTransactionalTemplate.handleGlobalTransaction(txInfo, () -> ((MethodInvocation)methodInvocation).proceed());
    }
}

