/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.seata.autoconfigure;

import com.jugg.agile.middleware.seata.aspect.JaGlobalTransactionalAspect;
import com.jugg.agile.middleware.seata.autoconfigure.JaSeataCoreAutoConfiguration;
import com.jugg.agile.middleware.seata.context.JaSeataRestTemplateInterceptor;
import com.jugg.agile.middleware.seata.utils.JaEnvironmentUtil;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.ScannerChecker;
import io.seata.spring.boot.autoconfigure.SeataAutoConfiguration;
import io.seata.spring.boot.autoconfigure.properties.SeataProperties;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import java.util.Collection;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnExpression(value="${ja.distributed-transaction.enabled:true}")
@AutoConfigureBefore(value={SeataAutoConfiguration.class})
@AutoConfigureAfter(value={JaSeataCoreAutoConfiguration.class})
public class JaGlobalTransactionAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoConfiguration.class);

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean
    @DependsOn(value={"springApplicationContextProvider", "failureHandler"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public static GlobalTransactionScanner globalTransactionScanner(SeataProperties seataProperties, FailureHandler failureHandler, ConfigurableListableBeanFactory beanFactory, @Autowired(required=false) List<ScannerChecker> scannerCheckers) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata");
        }
        GlobalTransactionScanner.setBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        GlobalTransactionScanner.addScannerCheckers((Collection)EnhancedServiceLoader.loadAll(ScannerChecker.class));
        GlobalTransactionScanner.addScannerCheckers(scannerCheckers);
        GlobalTransactionScanner.addScannablePackages((String[])seataProperties.getScanPackages());
        GlobalTransactionScanner.addScannerExcludeBeanNames((String[])seataProperties.getExcludesForScanning());
        GlobalTransactionScanner.setAccessKey((String)seataProperties.getAccessKey());
        GlobalTransactionScanner.setSecretKey((String)seataProperties.getSecretKey());
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }

    @Bean
    public DefaultPointcutAdvisor jaGlobalTransactionalAspect() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("@annotation(com.jugg.agile.middleware.seata.annotation.JaGlobalTransactional)");
        JaGlobalTransactionalAspect interceptor = new JaGlobalTransactionalAspect();
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }

    @Bean
    @ConditionalOnBean(value={RestTemplate.class})
    public JaSeataRestTemplateInterceptor jaSeataRestTemplateInterceptor(RestTemplate restTemplate) {
        JaSeataRestTemplateInterceptor jaSeataRestTemplateInterceptor = new JaSeataRestTemplateInterceptor();
        restTemplate.getInterceptors().add(jaSeataRestTemplateInterceptor);
        return jaSeataRestTemplateInterceptor;
    }

    @Bean
    public JaEnvironmentUtil jaEnvironmentUtil() {
        return new JaEnvironmentUtil();
    }
}

