package com.jugg.agile.middleware.seata.autoconfigure;

import io.seata.spring.boot.autoconfigure.provider.SpringApplicationContextProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import static io.seata.common.Constants.BEAN_NAME_SPRING_APPLICATION_CONTEXT_PROVIDER;

/**
 * 全局事务自动配置类
 *
 * @author wuzq
 * @version 1.0.0
 * @date 2024/06/06
 */
@ConditionalOnExpression("${ja.distributed-transaction.enabled:true}")
@ComponentScan(basePackages = "io.seata.spring.boot.autoconfigure.properties")
@Configuration
public class JaSeataCoreAutoConfiguration {

    @Bean(BEAN_NAME_SPRING_APPLICATION_CONTEXT_PROVIDER)
    @ConditionalOnMissingBean(name = {BEAN_NAME_SPRING_APPLICATION_CONTEXT_PROVIDER})
    public SpringApplicationContextProvider springApplicationContextProvider() {
        return new SpringApplicationContextProvider();
    }
}
