//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.jugg.agile.middleware.seata.jackson.plugin.parser.mysql;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.parser.spi.JacksonSerializer;
import java.io.IOException;
import java.sql.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(
    name = "mysqlTime"
)
public class MysqlTimeJacksonSerializer implements JacksonSerializer<Time> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlTimeJacksonSerializer.class);

    public MysqlTimeJacksonSerializer() {
    }

    @Override
    public Class<Time> type() {
        return Time.class;
    }

    @Override
    public JsonSerializer<Time> ser() {
        return new JsonSerializer<Time>() {
            @Override
            public void serializeWithType(Time time, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
                WritableTypeId typeId = typeSerializer.writeTypePrefix(gen, typeSerializer.typeId(time, JsonToken.VALUE_EMBEDDED_OBJECT));
                this.serialize(time, gen, serializers);
                gen.writeTypeSuffix(typeId);
            }

            @Override
            public void serialize(Time time, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(String.valueOf(time.getTime()));
            }
        };
    }

    @Override
    public JsonDeserializer<? extends Time> deser() {
        return new JsonDeserializer<Time>() {
            @Override
            public Time deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                Time time = new Time(p.getValueAsLong());
                return time;
            }
        };
    }
}
