package com.jugg.agile.openfeign;

import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.util.io.serialize.json.adapter.jackson.JaJacksonProcessor;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class JaOpenFeignConfiguration {

    @Bean
    public RequestInterceptor requestInterceptor() {
        return template -> JaMapContextChain.getInstance().transmit().forEach(template::header);
    }

    @Bean
    public Decoder feignDecoder() {
        return new ResponseEntityDecoder(new SpringDecoder(createHttpMessageConvertersObjectFactory()));
    }

    @Bean
    public Encoder feignEncoder() {
        return new SpringEncoder(createHttpMessageConvertersObjectFactory());
    }

    private ObjectFactory<HttpMessageConverters> createHttpMessageConvertersObjectFactory() {
        HttpMessageConverter<Object> jacksonConverter = new MappingJackson2HttpMessageConverter(JaJacksonProcessor.createObjectMapper());
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(jacksonConverter);
        return () -> httpMessageConverters;
    }
}
