/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.openfeign;

import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.util.io.serialize.json.adapter.jackson.JaJacksonProcessor;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class JaOpenFeignConfiguration {
    @Bean
    public RequestInterceptor requestInterceptor() {
        return template -> JaMapContextChain.getInstance().transmit().forEach((x$0, xva$1) -> template.header(x$0, new String[]{xva$1}));
    }

    @Bean
    public Decoder feignDecoder() {
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(this.createHttpMessageConvertersObjectFactory()));
    }

    @Bean
    public Encoder feignEncoder() {
        return new SpringEncoder(this.createHttpMessageConvertersObjectFactory());
    }

    private ObjectFactory<HttpMessageConverters> createHttpMessageConvertersObjectFactory() {
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(JaJacksonProcessor.createObjectMapper());
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{jacksonConverter});
        return () -> httpMessageConverters;
    }
}

