package com.jugg.agile.spring.boot.core;

import com.jugg.agile.framework.core.dapper.log.logback.JaLogback;
import com.jugg.agile.framework.core.dapper.log.logback.JaLogbackFilter;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class JaSpringApplicationRunListener implements SpringApplicationRunListener, Ordered {

    public JaSpringApplicationRunListener(SpringApplication springApplication, String[] args) {
    }


    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        if (Processor.isExecute()) {
            JaLogback.addFilter(JaLogbackFilter.class);
        }
    }

    @Override
    public void started(ConfigurableApplicationContext context) {
        if (Processor.isExecute()) {
            JaLogback.addFilter(JaLogbackFilter.class);
        }

    }

    @Override
    public int getOrder() {
        return 10;
    }

    public static class Processor {

        /**
         * 容错 cloud的 BootstrapApplicationListener
         */
        public static boolean isExecute() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (StackTraceElement stackTraceElement : stackTrace) {
                if (stackTraceElement.getClassName().endsWith("BootstrapApplicationListener")) {
                    return false; // 栈处于BootstrapApplicationListener中
                }
            }
            return true;
        }
    }
}