package com.jugg.agile.spring.boot.core;

public class JaSpringCloudProcessor {

    /**
     * 容错 cloud的 BootstrapApplicationListener
     * <p>
     * SpringApplicationRunListener
     * ApplicationContextInitializer
     * 都会重复执行
     *
     * @see org.springframework.cloud.bootstrap.BootstrapApplicationListener
     */
    public static boolean isCloudContainer() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (stackTraceElement.getClassName().endsWith("BootstrapApplicationListener")) {
                return true; // 栈处于BootstrapApplicationListener中
            }
        }
        return false;
    }
}
