package com.jugg.agile.spring.boot.core;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.config.JaSpringProperty;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;

import java.util.Map;
import java.util.Properties;

public class JaSpringPropertyProcessor {

    public static synchronized void setEnv(ConfigurableEnvironment environment) {
        String[] activeProfiles = environment.getActiveProfiles();
        if (JaCollectionUtil.isNotEmpty(activeProfiles)) {
            String activeProfile = activeProfiles[0];
            if (JaStringUtil.isEmpty(activeProfile)) {
                JaLog.get().warn("get activeProfile is empty");
            } else {
                JaSpringProperty.setEnv(activeProfile);
            }
        }
    }

    /**
     * JaProperty加载到Environment
     */
    public static synchronized void setEnvironment(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = getMutablePropertySources(environment);
        if (null != propertySources) {
            Properties properties = new Properties();
            JaProperty.getPropertyMap().forEach(properties::put);
            propertySources.addLast(new PropertiesPropertySource("jaProperties", properties));
        }
    }

    /**
     * 读取Spring配置到JaProperty
     */
    @SuppressWarnings({"unchecked"})
    public static synchronized void setProperty(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = getMutablePropertySources(environment);
        if (null != propertySources) {
            propertySources = environment.getPropertySources();
            propertySources.stream().forEach(propertySource -> {
                if (null != propertySource) {
                    Object source = propertySource.getSource();
                    if (source instanceof Map) {
                        Map<String, Object> sourceMap = (Map<String, Object>) source;
                        if (JaCollectionUtil.isNotEmpty(sourceMap)) {
                            sourceMap.forEach((s, o) -> JaProperty.getPropertyMap().put(s, o.toString()));
                        }
                    } else {
                        JaLog.info("unknown propertySource, name:{}", propertySource.getName());
                    }
                }
            });
        }
    }

    public static synchronized void init(ConfigurableEnvironment environment) {
        setEnv(environment);
        setProperty(environment);
        JaPropertyListener.executeCommonListener();
        JaPropertyListener.executeBizListener();
    }

    public static MutablePropertySources getMutablePropertySources(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = null;
        if (environment instanceof AbstractEnvironment) {
            propertySources = environment.getPropertySources();
        } else {
            JaLog.get().error("not support this environment{}", environment.getClass().getName());
        }
        return propertySources;
    }
}
