package com.jugg.agile.spring.boot.middleware;

import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import com.jugg.agile.middleware.db.datasource.aspect.JaConnectionAspect;
import com.jugg.agile.middleware.db.datasource.aspect.JaDataSourceAspect;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass({JaDataSourceAspect.class})
@ConditionalOnProperty(name = "ja.datasource.enabled", havingValue = "true")
//@ConditionalOnExpression("#{ '${ja.datasource.pool}' != null}")
public class JaDataSourceConfiguration implements InitializingBean {
    @Bean
    public JaDataSourceAspect dataSourceAspect() {
        return new JaDataSourceAspect();
    }

    @Bean
    public JaConnectionAspect connectionAspect() {
        return new JaConnectionAspect();
    }

    @Override
    public void afterPropertiesSet() {
        JaDataSourceFactory.create();
    }
}
