package com.jugg.agile.spring.boot.middleware;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.rocketmq.consumer.push.JaRocketMqPushConsumer;
import com.jugg.agile.middleware.rocketmq.consumer.push.JaRocketMqPushListener;
import com.jugg.agile.middleware.rocketmq.spring.JaRocketMqSpringUtil;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
@ConditionalOnClass({JaRocketMqPushConsumer.class})
public class JaRocketMqConfiguration implements SmartInitializingSingleton {

    @Autowired(required = false)
    @SuppressWarnings("rawtypes")
    private List<JaRocketMqPushListener> listenerList;

    @Override
    public void afterSingletonsInstantiated() {
        if (JaCollectionUtil.isEmpty(listenerList)) {
            return;
        }
        String defaultNamesrvAddr = JaRocketMqPushConsumer.getNamesrvAddr(JaRocketMqPushConsumer.DefaultFlag);
        if (JaStringUtil.isEmpty(defaultNamesrvAddr)) {
            defaultNamesrvAddr = JaProperty.get("rocketmq.name-server");
            if (JaStringUtil.isEmpty(defaultNamesrvAddr)) {
                defaultNamesrvAddr = JaProperty.get("rocketmq.nameServer");
            }
            if (JaStringUtil.isEmpty(defaultNamesrvAddr)) {
                throw new RuntimeException("create rocketmq consumer error:namesrvAddr is null");
            }
            JaProperty.getPropertyMap().put("ja.rocketmq." + JaRocketMqPushConsumer.DefaultFlag + ".namesrvAddr", defaultNamesrvAddr);
        }
        JaRocketMqPushConsumer.createByListenerInfo(JaRocketMqSpringUtil.getPushListenerInfo(listenerList));
    }
}
