package com.jugg.agile.spring.boot.util;

import com.jugg.agile.framework.core.util.JaStringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;

import java.util.Locale;

/**
 * 国际化工具类
 *
 * @author chenjian
 * @since 2023年03月09日 15:57:28
 */
public class JaI18nUtil {
    public static final String Header = "accept-language";
    public static final String HeaderUp = "Accept-Language";

    protected static MessageSourceAccessor accessor;
    public static final Locale DefaultLocale = Locale.ENGLISH;

    public static String getMessage(String code, Object... args) {
//        GcsmSysContextEntity sysContextEntity = GcsmSysContext.get();
        Locale locale = DefaultLocale;

//        if (null != sysContextEntity) {
//            locale = sysContextEntity.getLocale();
//        }
        return getMessage(code, locale, args);
    }

    public static String getMessage(String code, Locale locale, Object... args) {
        if (null == accessor) {
            return code;
        }
        if (null == locale) {
            locale = DefaultLocale;
        }
        try {
            return accessor.getMessage(code, args, locale);
        } catch (NoSuchMessageException e) {
            try {
                return accessor.getMessage("GcsmErrorCode.C01O001", locale) + ":" + code;
            } catch (Throwable ee) {
                return code;
            }
        }
    }

    /**
     * 通过异常和指定locale获取错误码
     */
//    public static String getMessage(Throwable throwable, Locale locale) {
//        String code = GcsmErrorCode.C01O002;
//        Object[] codeFormatArgs = null;
//        if (throwable instanceof GcsmBaseException) {
//            GcsmBaseException baseException = (GcsmBaseException) throwable;
//            code = baseException.getCode();
//            codeFormatArgs = baseException.getCodeFormatArgs();
//        }
//        return getMessage(code, locale, codeFormatArgs);
//    }

    /**
     * 获取字符串AcceptLanguage构建Locale, 容错tomcat复用请求时不做解析的bug
     */
    public static Locale parseLocales(String acceptLanguage) {
        if (JaStringUtil.isEmpty(acceptLanguage)) {
            return DefaultLocale;
        }

        String[] language = acceptLanguage.split(";")[0].split(",")[0].split("-");
        if (language.length == 2) {
            return new Locale(language[0], language[1]);
        } else if (language.length == 1) {
            return new Locale(language[0]);
        }
        return DefaultLocale;
    }

    /**
     * 构建MessageSource, 以便后续出现后端国际化需求
     *
     * @author chenjian
     * @since 2023年03月09日 19:38:19
     */
    @Configuration
    public static class JaI18nConfiguration {
        @Value("${ja.spring.i18n.basenames:''}")
        private String basenames;

        @Bean
        public MessageSource messageSource() {
            ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
            // 描述性资源
            messageSource.setBasenames(
                    "i18n-framework/businessMessage"
            );
            if (JaStringUtil.isNotEmpty(basenames)) {
                messageSource.setBasenames(basenames);
            }
            messageSource.setDefaultEncoding("UTF-8");
            messageSource.setUseCodeAsDefaultMessage(false);
            return messageSource;
        }

        @Configuration
        @ConditionalOnBean({MessageSource.class})
        public static class MessageSourceAwareConfiguration implements MessageSourceAware {
            @Override
            @SuppressWarnings("all")
            public void setMessageSource(MessageSource messageSource) {
                JaI18nUtil.accessor = new MessageSourceAccessor(messageSource);
            }
        }
    }
}
