package com.jugg.agile.spring.boot.util;

import com.alibaba.fastjson.JSON;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.io.net.http.meta.JaHttpHeaders;
import com.jugg.agile.framework.core.util.io.net.http.meta.JaContentTypeEnum;
import lombok.SneakyThrows;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;

public class JaServletUtil {

    public static String getUserAgent(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        return request.getHeader(JaHttpHeaders.USER_AGENT);
    }

    /**
     * servlet 打印 response
     *
     * @author chenjian
     * @since 2020年09月29日 10:21:13
     */
    @SneakyThrows
    public static void printResponse(HttpServletRequest request, HttpServletResponse response, Object object) {
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(JaContentTypeEnum.Json.getContentType(StandardCharsets.UTF_8));
        try {
            out.write(JSON.toJSONString(object).getBytes());
        } catch (Throwable e) {
            out.write(JSON.toJSONString(String.format("response print error:[%s:%s:%s]"
                    , request.getRequestURL()
                    , object.getClass().getSimpleName()
                    , JaMDC.get())
                    ).getBytes()
            );
        }
        out.flush();
    }
}
