package com.jugg.agile.spring.boot.util;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;

public class JaSpringServletUtil {

    public static HttpServletRequest getHttpServletRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        Object resolveReference = requestAttributes.resolveReference(RequestAttributes.REFERENCE_REQUEST);
        if (null == resolveReference) {
            return null;
        }
        return (HttpServletRequest) resolveReference;
    }

    public static String getUserAgent() {
        return JaServletUtil.getUserAgent(getHttpServletRequest());
    }
}
