package com.jugg.agile.spring.boot.web.context;


import com.jugg.agile.framework.core.context.chain.MapTargetContextChain;

import javax.servlet.http.HttpServletRequest;

/**
 * HTTP协议传输的链路
 *
 * @author chenjian
 * @since 2023年03月10日 11:55:25
 */
@SuppressWarnings("rawtypes")
public class WebContextChain extends MapTargetContextChain<HttpServletRequest, WebContextLink> {
    private static volatile WebContextChain instance;

    public static WebContextChain getInstance() {
        if (instance == null) {
            synchronized (WebContextChain.class) {
                if (instance == null) {
                    instance = new WebContextChain();
                }
            }
        }
        return instance;
    }

    private WebContextChain() {
    }
}
