package com.jugg.agile.spring.boot.web.context.link;

import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.web.context.WebContextLink;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * traceId 适配 MDC
 * traceId 在山下文中冗余一份, 以便传递
 *
 * @author chenjian
 * @since 2023年04月02日 18:35:00
 */
public class TraceIdContextLink implements WebContextLink<JaCoreContextEntity> {
    @Override
    public void inherit(HttpServletRequest source, JaCoreContextEntity target) {
        String traceId = source.getHeader(JaMDC.TraceId);
        JaMDC.put(JaStringUtil.isEmpty(traceId) ? JaMDC.createTraceId() : traceId);
        target.setTraceId(JaMDC.get());
    }

    @Override
    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        addHeader(target, JaMDC.TraceId, source.getTraceId());
    }

    @Override
    public void remove() {
        JaMDC.remove();
    }

    @Override
    public int order() {
        return Integer.MIN_VALUE;
    }
}
