package com.jugg.agile.spring.boot.web.servlet;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.JaStringUtil;
import lombok.SneakyThrows;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;

/**
 * controller 前置处理, 以防三分包内置controller未拦截到
 *
 * @author chenjian
 * @since 2024年01月05日 19:35:06
 */
public class JaServletFilter implements Filter {
    @Override
    public void init(FilterConfig filterConfig) {
        JaLog.info("JaServletFilter init");
    }

    @Override
    @SneakyThrows
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String requestURI = request.getRequestURI();
        StringBuffer requestURL = request.getRequestURL();

        try {
            // 不处理handler

//            HttpContextChain.getInstance().inherit(request);
//            JaLog.info("url:{} sysContext:[{}]"
//                    , request.getRequestURI()
//                    , JSON.toJSONString(GcsmSysContext.get())
//            );
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            if (JaStringUtil.isEmpty(response.getHeader(JaMDC.TraceId))) {
                response.addHeader(JaMDC.TraceId, JaMDC.get());
            }
            chain.doFilter(servletRequest, servletResponse);
        } catch (Throwable e) {
//            handleException(request, response, e);
        } finally {
//            HttpContextChain.getInstance().remove();
        }
    }

    @Override
    public void destroy() {
        JaLog.info("JaServletFilter destroy");
    }


    @Configuration
    public static class Register {
        @Bean
        public FilterRegistrationBean<JaServletFilter> registerJaServletFilter() {
            FilterRegistrationBean<JaServletFilter> registration = new FilterRegistrationBean<>();
            registration.setFilter(new JaServletFilter());
            registration.addUrlPatterns("/*");
            registration.setName("jaServletFilter");
            registration.setOrder(Integer.MIN_VALUE + 10);
            return registration;
        }
    }
}
