package com.jugg.agile.spring.boot.webmvc;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaThrowableUtil;
import com.jugg.agile.framework.meta.dto.JaResultDTO;
import com.jugg.agile.framework.meta.exception.JaException;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import com.jugg.agile.spring.boot.util.JaSpringExecptionUtil;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.servlet.http.HttpServletRequest;
import java.util.Locale;

//@ControllerAdvice
public abstract class JaResponseBodyAdvice implements ResponseBodyAdvice<Object> {

    public abstract String errorCode();

    public abstract String okCode();

    @Override
    public boolean supports(@Nullable MethodParameter returnType, @Nullable Class<? extends HttpMessageConverter<?>> converterType) {
        boolean isIO = returnType == null
                || returnType.getParameterType() == Resource.class
                || returnType.getParameterType() == InputStreamResource.class
                || returnType.getParameterType() == ResponseEntity.class;
        return !isIO;
    }


    @Nullable
    @Override
    public Object beforeBodyWrite(@Nullable Object body, @Nullable MethodParameter returnType,
                                  @Nullable MediaType selectedContentType, @Nullable Class selectedConverterType,
                                  @Nullable ServerHttpRequest request, @Nullable ServerHttpResponse response) {
        if (body instanceof JaResultParseHandler) {
            return body;
        }
        return new JaResultDTO<>(body).buildCode(okCode());
    }

    @ResponseBody
    @ExceptionHandler(value = Throwable.class)
    public ResponseEntity<Object> defaultErrorHandler(HttpServletRequest req, Throwable e) {
        String path = req.getRequestURL().toString();
        String code = errorCode();
        String codeMsg;
        String codeMsgLog = null;
        if (e instanceof MethodArgumentNotValidException) {
            codeMsg = JaSpringExecptionUtil.executeMethodArgumentNotValidException(path, (MethodArgumentNotValidException) e);
            JaLog.error("{} valid error:{}", path, codeMsg);
        } else {
            Throwable cause = JaThrowableUtil.getCause(e);
            if (cause instanceof JaException) {
                code = ((JaException) cause).getCode();
                codeMsg = ((JaException) cause).getCodeMsg();
                if (JaStringUtil.isNotEmpty(code) && JaStringUtil.isEmpty(codeMsg)) {
                    codeMsg = JaI18nUtil.getMessage(code, ((JaException) cause).getCodeFormatArgs());
                    codeMsgLog = JaI18nUtil.getMessage(code, Locale.CHINA, ((JaException) cause).getCodeFormatArgs());
                }
            } else {
                codeMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
                codeMsgLog = codeMsg;
            }

            JaLog.error("{} error : {}", path, codeMsgLog, e);
        }
        JaResultDTO<Object> resultDTO = new JaResultDTO<>();
        resultDTO.setCode(code);
        resultDTO.setCodeMsg(codeMsg);
        return new ResponseEntity<>(resultDTO, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}
