/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.webmvc;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaThrowableUtil;
import com.jugg.agile.framework.meta.dto.JaResultDTO;
import com.jugg.agile.framework.meta.exception.JaException;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import com.jugg.agile.spring.boot.util.JaSpringExecptionUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public abstract class JaResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    public abstract String errorCode();

    public abstract String okCode();

    public abstract HttpStatus errorHttpStatus();

    public boolean supports(@Nullable MethodParameter returnType, @Nullable Class<? extends HttpMessageConverter<?>> converterType) {
        boolean isIO = returnType == null || returnType.getParameterType() == Resource.class || returnType.getParameterType() == InputStreamResource.class || returnType.getParameterType() == ResponseEntity.class;
        return !isIO;
    }

    @Nullable
    public Object beforeBodyWrite(@Nullable Object body, @Nullable MethodParameter returnType, @Nullable MediaType selectedContentType, @Nullable Class selectedConverterType, @Nullable ServerHttpRequest request, @Nullable ServerHttpResponse response) {
        if (body instanceof JaResultParseHandler) {
            return body;
        }
        return new JaResultDTO(body).buildCode(this.okCode());
    }

    @ResponseBody
    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<Object> defaultErrorHandler(HttpServletRequest req, Throwable e) {
        String codeMsg;
        String path = req.getRequestURL().toString();
        String code = this.errorCode();
        String codeMsgLog = null;
        if (e instanceof MethodArgumentNotValidException) {
            codeMsg = JaSpringExecptionUtil.executeMethodArgumentNotValidException((String)path, (MethodArgumentNotValidException)((MethodArgumentNotValidException)e));
            JaLog.error((String)"{} valid error:{}", (Object[])new Object[]{path, codeMsg});
        } else {
            Throwable cause = JaThrowableUtil.getCause((Throwable)e);
            if (cause instanceof JaException) {
                code = ((JaException)cause).getCode();
                codeMsg = ((JaException)cause).getCodeMsg();
                if (JaStringUtil.isNotEmpty((String)code) && JaStringUtil.isEmpty((String)codeMsg)) {
                    codeMsg = JaI18nUtil.getMessage((String)code, (Object[])((JaException)cause).getCodeFormatArgs());
                    codeMsgLog = JaI18nUtil.getMessage((String)code, (Locale)Locale.CHINA, (Object[])((JaException)cause).getCodeFormatArgs());
                }
            } else {
                codeMsgLog = codeMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
            }
            JaLog.error((String)"{} error : {}", (Object[])new Object[]{path, codeMsgLog, e});
        }
        JaResultDTO resultDTO = new JaResultDTO();
        resultDTO.setCode(code);
        resultDTO.setCodeMsg(codeMsg);
        return new ResponseEntity((Object)resultDTO, this.errorHttpStatus());
    }
}

