/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.webmvc.dapper;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.context.biz.JaCoreContext;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarm;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarmMessage;
import com.jugg.agile.framework.core.dapper.alarm.adapter.qywx.JaQyWxAlarm;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.function.JaFunctionP;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JaDapperWebProcessor {
    private static long servletConnNums;
    private static boolean servletConnNumsStop;
    private static boolean checkUnknownUpServer;
    private static final JaQyWxAlarm alarmUnknownUpServer;
    private static final HashSet<String> unknownUpServerIPSet;
    public static final AtomicInteger Concurrency;

    public static void dapper(HttpServletRequest request, HttpServletResponse response) {
        request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (JaStringUtil.isEmpty((String)response.getHeader(JaMDC.KeyTraceId))) {
            response.setHeader("Access-Control-Expose-Headers", JaMDC.KeyTraceId);
            response.addHeader(JaMDC.KeyTraceId, JaMDC.get());
        }
    }

    private void alarm(int connNums) {
        if (servletConnNumsStop && (long)connNums > servletConnNums) {
            try {
                String error = String.format("servlet current thread : %s > %s", connNums, servletConnNums);
                JaLog.info((String)error, (Object[])new Object[0]);
                JaFunctionP alarmHandler = JaAlarm.getAlarmHandler();
                if (null != alarmHandler) {
                    alarmHandler.apply((Object)(JaAlarmMessage.getCommonMessage() + error));
                }
            }
            catch (Throwable e) {
                JaLog.error((String)"servlet connection nums alarm error", (Object[])new Object[]{e});
            }
        }
        Concurrency.decrementAndGet();
    }

    public static void checkUpServer(HttpServletRequest request) {
        JaCoreContextEntity jaCoreContextEntity = JaCoreContext.getInstance().get();
        String usIp = jaCoreContextEntity.getUsIp();
        if (checkUnknownUpServer && JaStringUtil.isEmpty((String)jaCoreContextEntity.getUsName()) && JaStringUtil.isNotEmpty((String)usIp) && !JaServletUtil.isFromWeb(request) && !unknownUpServerIPSet.contains(usIp)) {
            alarmUnknownUpServer.alarm(JaAlarmMessage.getCommonMessage() + "\u672a\u77e5\u6765\u6e90IP:" + jaCoreContextEntity.getUsIp());
            unknownUpServerIPSet.add(jaCoreContextEntity.getUsIp());
            if (unknownUpServerIPSet.size() > 10000) {
                alarmUnknownUpServer.alarm(JaAlarmMessage.getCommonMessage() + "\u672a\u77e5\u6765\u6e90IP\u6570\u6e05\u7a7a\u7f13\u5b58");
                unknownUpServerIPSet.clear();
            }
        }
    }

    static {
        unknownUpServerIPSet = new HashSet();
        Concurrency = new AtomicInteger();
        alarmUnknownUpServer = new JaQyWxAlarm("checkUpServer");
        alarmUnknownUpServer.setUrl("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=c8e9019c-fb68-4281-ba47-690be69fb47a");
        JaPropertyListener.addAndRunCommonListener(() -> {
            checkUnknownUpServer = JaProperty.getBoolean((String)"ja.servlet.checkUnknownUpServer", (Boolean)false);
        });
    }
}

