package com.jugg.agile.spring.boot.webmvc;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;

public class JaWebPostPropertyHandler implements JaPostPropertyHandler {


    @Override
    public void addAndCover() {
        JaLog.info("swagger enabled:{}", JaEnvProperty.isLocal());
        JaProperty.getPropertyMap().put("springfox.documentation.enabled", JaEnvProperty.isLocal());


        // 配置 Tomcat 能够同时处理的最大连接数。这是服务器允许的总连接数上限，超过此数量的连接请求将被拒绝或进入等待队列。
//        JaProperty.getPropertyMap().putIfAbsent("server.tomcat.max-connections", 10000 );
    }

    @Override
    public int order() {
        return 100;
    }
}
