/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.webmvc.servlet;

import com.jugg.agile.framework.core.context.biz.JaCoreContext;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaThrowableUtil;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import com.jugg.agile.framework.meta.dto.JaResultDTO;
import com.jugg.agile.framework.meta.exception.JaException;
import com.jugg.agile.spring.boot.webmvc.context.JaWebContextChain;
import com.jugg.agile.spring.boot.webmvc.servlet.JaServletConfig;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JaServletFilter
implements Filter {
    private static final String logFormatEntry = "url:{},context:{}";

    public void init(FilterConfig filterConfig) {
        JaWebContextChain instance = JaWebContextChain.getInstance();
        JaLog.info((String)"JaServletFilter init:{}", (Object[])new Object[]{instance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = request.getRequestURI();
        try {
            JaWebContextChain.getInstance().inherit(request);
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            if (JaStringUtil.isEmpty((String)response.getHeader(JaMDC.TraceId))) {
                response.addHeader(JaMDC.TraceId, JaMDC.get());
            }
            if (JaServletConfig.isPass(requestURI)) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            JaLog.info((String)logFormatEntry, (Object[])new Object[]{requestURI, JaJson.toString((Object)JaCoreContext.getInstance().get())});
            chain.doFilter(servletRequest, servletResponse);
        }
        catch (Throwable e) {
            JaServletFilter.handleException(request, response, e);
        }
        finally {
            JaWebContextChain.getInstance().remove();
        }
    }

    public void destroy() {
        JaLog.info((String)"JaServletFilter destroy", (Object[])new Object[0]);
    }

    protected static void handleException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        JaLog.get().error("http filter catch ex", e);
        e = JaThrowableUtil.getCause((Throwable)e);
        String code = null;
        String codeMsg = null;
        if (e instanceof JaException) {
            code = ((JaException)e).getCode();
        }
        codeMsg = String.format("Unknown Error:[%s]-[%s]", request.getRequestURI(), JaMDC.get());
        JaResultDTO result = new JaResultDTO();
        result.setCode(code);
        result.setCodeMsg(codeMsg);
        response.setStatus(505);
        JaServletUtil.printResponse(request, response, result);
    }
}

