package com.jugg.agile.spring.boot.webmvc;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.io.net.JaIPUtil;
import com.jugg.agile.spring.boot.webmvc.servlet.JaServletConfig;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import springfox.boot.starter.autoconfigure.OpenApiAutoConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;


//@EnableSwagger2
//@ConditionalOnWebApplication

/**
 * @author chenjian
 * @see OpenApiAutoConfiguration starter 默认启用, 需要手动禁用
 * <p>
 * swagger-resources/configuration/ui
 * @since 2024年09月10日 13:35:46
 */
//@Configuration
@ConditionalOnProperty(value = "springfox.documentation.enabled", havingValue = "true", matchIfMissing = true)
public class JaSwaggerConfiguration {

    @Bean
    public Docket docket() {
        String basePackage = JaProperty.get("ja.swagger.basePackage");
        if (JaStringUtil.isEmpty(basePackage)) {
            JaLog.warn("ja swagger init error, basePackage isEmpty");
            return null;
        }
        String contextPath = JaServletUtil.getContextPath();
        JaServletConfig.getPassUrlSet().add(contextPath + "doc.html");
        JaServletConfig.getPassUrlSet().add(contextPath + "favicon.ico");
        JaServletConfig.getPassUrlSet().add(contextPath + "swagger-resources");
        JaServletConfig.getPassUrlSet().add(contextPath + "v2/api-docs");
        JaServletConfig.getPassUrlSet().add(contextPath + "webjars");

        String version = JaEnvProperty.getVersion();
        if (JaStringUtil.isEmpty(version)) {
            version = "local";
        }
        JaLog.info("swagger2 knife4j : {}", String.format("http://%s:%s%sdoc.html#/home"
                , JaIPUtil.getLocalIP()
                , JaServletUtil.getPort()
                , contextPath
                )
        );
        return new Docket(DocumentationType.SWAGGER_2)
                .enable(!JaEnvProperty.isCD())
                .apiInfo(new ApiInfoBuilder()
                        .version(JaProperty.get("ja.swagger.version", version))
                        .title(JaProperty.get("ja.swagger.title", JaEnvProperty.getApplicationName()))
                        .description(JaProperty.get("ja.swagger.description", "swagger2接口"))
                        .termsOfServiceUrl(JaProperty.get("ja.swagger.termsOfServiceUrl", contextPath))
                        .contact(new Contact(JaProperty.get("ja.swagger.author", "jugg")
                                , "url"
                                , null))
                        .build())
                .groupName(JaProperty.get("ja.swagger.groupName", "groupName"))
                .select()
                .apis(RequestHandlerSelectors.basePackage(basePackage))
                .paths(PathSelectors.any())
                .build();
    }

//    @Configuration
    @ConditionalOnBean(WebMvcConfigurationSupport.class)
    @ConditionalOnProperty(value = "springfox.documentation.enabled", havingValue = "true", matchIfMissing = true)
    public static class JaSwaggerWebMvcConfigurationSupport extends WebMvcConfigurationSupport {

        @Override
        protected void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler("/doc.html").addResourceLocations("classpath*:/META-INF/resources/");
            registry.addResourceHandler("/webjars/**").addResourceLocations("classpath*:/META-INF/resources/webjars/");

        }
    }
}