package com.jugg.agile.spring.boot.webmvc.dapper;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.boot.webmvc.util.JaSpringServletUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.io.InputStreamSource;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartRequest;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;

@Component
@ConditionalOnClass({Controller.class})
public class JaNodeSpanWeb implements JaNodeSpanResolver, JaDapperAspectPointcut {

    private static final NodeKind webNodeKind = new NodeKind("web", true)
            .buildIdHandler(methodInvocation -> {
                HttpServletRequest httpServletRequest = JaSpringServletUtil.getHttpServletRequest();
                return null == httpServletRequest ? "unknown.servlet.uri" : JaSpringServletUtil.getHttpServletRequest().getRequestURI();
            })
            .buildReqArgsHandler(args -> {
                if (JaCollectionUtil.isEmpty(args)) {
                    return args;
                }
                ArrayList<Object> objects = new ArrayList<>(args.length);
                for (Object arg : args) {
                    if (arg instanceof ServletRequest
                            || arg instanceof ServletResponse
                            || arg instanceof MultipartRequest
                            || arg instanceof InputStreamSource
                    ) {
                        continue;
                    }
                    objects.add(arg);
                }
                return objects.toArray();
            });

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        if (null != JaAopUtil.getClassAnnotation(invocation, RestController.class)
                || null != JaAopUtil.getClassAnnotation(invocation, Controller.class)
        ) {
            return get(webNodeKind);
        }
        return null;
    }

    @Override
    public String getExpression() {
        String expression = JaProperty.get("ja.dapper.aspect.pointcut.web");
        if (JaStringUtil.isNotEmpty(expression)) {
            return expression;
        }

        return String.format("%s || %s"
                , "@within(org.springframework.web.bind.annotation.RestController)"
                , "@within(org.springframework.stereotype.Controller)"
        );
//
//        String rootPackage = JaSpringUtil.getRootPackage();
//        return String.format("%s && (%s || %s)"
//                , "execution(* " + rootPackage + "..*.*(..))"
//                , "@within(org.springframework.web.bind.annotation.RestController)"
//                , "@within(org.springframework.stereotype.Controller)"
//        );
    }
}
