package com.jugg.agile.spring.boot.webmvc.dapper;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.context.biz.JaCoreContext;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarm;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarmMessage;
import com.jugg.agile.framework.core.dapper.alarm.adapter.qywx.JaQyWxAlarm;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;
import lombok.SneakyThrows;
import org.springframework.http.HttpHeaders;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class JaDapperWebProcessor {

    private static long servletConnNums;
    private static boolean servletConnNumsStop;
    private static boolean checkUnknownUpServer;
    private static final JaQyWxAlarm alarmUnknownUpServer;
    private static final HashSet<String> unknownUpServerIPSet = new HashSet<>();
    public static final AtomicInteger Concurrency = new AtomicInteger();

    static {
        alarmUnknownUpServer = new JaQyWxAlarm("checkUpServer");
        alarmUnknownUpServer.setUrl("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=c8e9019c-fb68-4281-ba47-690be69fb47a");
        JaPropertyListener.addAndRunCommonListener(() -> {
            checkUnknownUpServer = JaProperty.getBoolean("ja.servlet.checkUnknownUpServer", false);
        });
    }

    @SneakyThrows
    public static void dapper(HttpServletRequest request, HttpServletResponse response) {
        request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (JaStringUtil.isEmpty(response.getHeader(JaMDC.TraceId))) {
            response.setHeader(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, JaMDC.TraceId);
            response.addHeader(JaMDC.TraceId, JaMDC.get());
        }
    }

    private void alarm(int connNums) {
        if (servletConnNumsStop && connNums > servletConnNums) {
            try {
                String error = String.format("servlet current thread : %s > %s", connNums, servletConnNums);
                JaLog.info(error);
                JaFunctionP<String> alarmHandler = JaAlarm.getAlarmHandler();
                if (null != alarmHandler) {
                    alarmHandler.apply(JaAlarmMessage.getCommonMessage() + error);
                }
            } catch (Throwable e) {
                JaLog.error("servlet connection nums alarm error", e);
            }
        }
        Concurrency.decrementAndGet();
    }

    /**
     * 检查未知上游服务告警
     */
    public static void checkUpServer(HttpServletRequest request) {
        JaCoreContextEntity jaCoreContextEntity = JaCoreContext.getInstance().get();
        String usIp = jaCoreContextEntity.getUsIp();
        if (checkUnknownUpServer
                && JaStringUtil.isEmpty(jaCoreContextEntity.getUsName())
                && JaStringUtil.isNotEmpty(usIp)
                && !JaServletUtil.isFromWeb(request)
                && !unknownUpServerIPSet.contains(usIp)
        ) {
            alarmUnknownUpServer.alarm(JaAlarmMessage.getCommonMessage() + "未知来源IP:" + jaCoreContextEntity.getUsIp());
            unknownUpServerIPSet.add(jaCoreContextEntity.getUsIp());
            if (unknownUpServerIPSet.size() > 10000) {
                alarmUnknownUpServer.alarm(JaAlarmMessage.getCommonMessage() + "未知来源IP数清空缓存");
                unknownUpServerIPSet.clear();
            }
        }
    }
}
